% Simple Example program to obtain time data from E1432A
% Rev 6-18-97
% Hit "Control C" to exit

BLOCKSIZE = 1024
OLDCHANNELS = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16]
CHANNELS  = [1 2 3 4]
SPAN = 20000.
RANGE = 10.0

Xtime = 1/(SPAN*2.56):1/(SPAN*2.56):BLOCKSIZE/(SPAN*2.56);  % time axis values

[status,session] = hpe1432('init','VXI0::8::INSTR',1,1);   % init module at address 8 

						
[status] = hpe1432('deleteAllChanGroups',session);		% Turn off all channels 

[status,gid] = hpe1432('createChannelGroup',session,length(OLDCHANNELS),OLDCHANNELS);

[status] = hpe1432('setActive',session,gid,'CHANNEL_OFF');  
						  
[status] = hpe1432('deleteAllChanGroups',session);		% Create a group of 4 active channels

[status,gid] = hpe1432('createChannelGroup',session,length(CHANNELS),CHANNELS);

[status] = hpe1432('setBlocksize',session,gid,BLOCKSIZE);	% set the block size of all active channels

[status] = hpe1432('setRange',session,gid,RANGE);		% Set the full scale voltage range of all 								% active achnnels

[status] = hpe1432('setSpan',session,gid,SPAN);		% set the SPAN (sample rate/2.56)

[status] = hpe1432('setDataMode',session,gid,'BLOCK_MODE');	% Put module in block acquisition 									% mode

[status] = hpe1432('setAutoTrigger',session,gid,'MANUAL_TRIGGER');	% set trigger mode 

[status] = hpe1432('initMeasure',session,gid);  		% start measurement	
A=1
while A>0,
   
[status] = hpe1432('triggerMeasure',session,gid,'NO_WAIT_FLAG'); 	 % manually trigger a block 									% acquisition of all channels
[status,data,count] = hpe1432('readFloat64Data',session,gid,'TIME_DATA',BLOCKSIZE*length(CHANNELS),'WAIT_FLAG');		
		% transfer all four channels of data at 1024 samples (blocksize) per channel

plot(Xtime,reshape(data,BLOCKSIZE,length(CHANNELS))), drawnow;

A=A+1
end
		% The following would normally be used to clean up the measurement when 				% finished.  In this example this never gets executed, since the example runs until 			% "control C" is hit.

[status] = hpe1432('finishMeasure',session,gid);
[status] = hpe1432('close',session);
